/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.geometry.mixin.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.models.geometry.GeometryLoaderManager;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_793.class_795.class})
public abstract class BlockModelDeserializerMixin {
    @Inject(method={"deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/client/renderer/block/model/BlockModel;"}, at={@At(value="RETURN")}, cancellable=true)
    public void modelLoading(JsonElement element, Type type, JsonDeserializationContext deserializationContext, CallbackInfoReturnable<class_793> cir) {
        class_793 model = (class_793)cir.getReturnValue();
        JsonObject jsonobject = element.getAsJsonObject();
        IUnbakedGeometry<?> geometry = BlockModelDeserializerMixin.deserializeGeometry(deserializationContext, jsonobject);
        List elements = model.method_3433();
        if (geometry != null) {
            elements.clear();
            model.setCustomGeometry(geometry);
        }
        if (jsonobject.has("transform")) {
            JsonObject transform = class_3518.method_15296((JsonObject)jsonobject, (String)"transform");
            model.setRootTransform((class_4590)deserializationContext.deserialize((JsonElement)transform, class_4590.class));
        }
        if (jsonobject.has("visibility")) {
            JsonObject visibility = class_3518.method_15296((JsonObject)jsonobject, (String)"visibility");
            for (Map.Entry part : visibility.entrySet()) {
                model.getVisibilityData().setVisibilityState((String)part.getKey(), ((JsonElement)part.getValue()).getAsBoolean());
            }
        }
    }

    @Unique
    @Nullable
    private static IUnbakedGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) throws JsonParseException {
        String loaderId = GeometryLoaderManager.getModelLoader(object);
        if (loaderId == null) {
            return null;
        }
        class_2960 name = new class_2960(loaderId);
        IGeometryLoader<?> loader = GeometryLoaderManager.get(name);
        if (loader == null) {
            if (!GeometryLoaderManager.KNOWN_MISSING_LOADERS.contains(name)) {
                GeometryLoaderManager.KNOWN_MISSING_LOADERS.add(name);
                PortingLib.LOGGER.warn(String.format(Locale.ENGLISH, "Model loader '%s' not found. Registered loaders: %s", name, GeometryLoaderManager.getLoaderList()));
                PortingLib.LOGGER.warn("Falling back to vanilla logic.");
            }
            return null;
        }
        return loader.read(object, deserializationContext);
    }
}

